﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private ExerciseBL _ExerciseBL = null;

        public ExerciseBL Exercise
        {
            get
            {
                if (_ExerciseBL == null)
                {
                    _ExerciseBL = new ExerciseBL(this);
                }

                return _ExerciseBL;
            }
        }

        public class ExerciseBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public ExerciseBL(ZSBELearning BL) : base(BL) { }

            #region Navigation
            private NavigationBL _NavigationBL = null;

            public NavigationBL Navigation
            {
                get
                {
                    if (_NavigationBL == null)
                    {
                        _NavigationBL = new NavigationBL(BLP);
                    }
                    return _NavigationBL;
                }
            }

            public class NavigationBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public NavigationBL(ZSBELearning BL) : base(BL) { }

                public BL.ZSBELearning.ContextParam RestoreStartExercise(Gemini.Core.BL.Interface.IUserGroup User,long? ContextObjectID, long? CourseID, long? StatisticContextID)
                {
                    BL.ZSBELearning.ContextParam _ContextParam = new ContextParam(BLP, ContextObjectID, CourseID, StatisticContextID, GM.N610.ELearning.BL.Dictionary.ModeType.None);

                    if ((_ContextParam.Group == Dictionary.GroupType.Student) && !_ContextParam.IsCompetencePartAvailable && !_ContextParam.IsCourseFinished)
                    {
                            _ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;
                    }
                    else
                    {
                        #region CompetenceTheory
                        if (_ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceTheory)
                        {
                            _ContextParam = RestoreStartExercise_NormalMode(_ContextParam);
                        }
                        #endregion
                        else
                        {
                            #region Reszta kursów
                            if (_ContextParam.Group == Dictionary.GroupType.Student)
                            {
                                if (_ContextParam.IsCourseFinished)
                                {
                                    _ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.StartSummary;
                                    _ContextParam.Mode = GM.N610.ELearning.BL.Dictionary.ModeType.History;
                                }
                                else
                                {
                                    _ContextParam = Restore_RandomMode(_ContextParam);
                                }
                            }
                            else
                            {
                                _ContextParam = RestoreStartExercise_NormalMode(_ContextParam);
                            }
                            #endregion
                        }
                    }

                    if ((_ContextParam.Group == Dictionary.GroupType.Student) && (_ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None))
                    {
                        if ((_ContextParam.CourseType != Dictionary.Category.CourseType.CompetenceTheory) && !_ContextParam.IsCourseFinished && !_ContextParam.IsValidContext)
                        {
                            _ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Redirect;
                        }
                    }

                    return _ContextParam;
                }

                public BL.ZSBELearning.ContextParam RestoreStartExercise(Gemini.Core.BL.Interface.IUserGroup User, long? ContextObjectID, long? CourseID, long UnitID, long? StatisticContextID)
                {
                    BL.ZSBELearning.ContextParam _ContextParam = new ContextParam(BLP, ContextObjectID, CourseID, StatisticContextID, GM.N610.ELearning.BL.Dictionary.ModeType.None);

                    PI.GM.N610.ELearning.BL.BO.Unit _unit = BLP.BLELearning.Unit.Restore(UnitID);

                    if (_unit != null)
                    {
                        _ContextParam = RestoreStartExercise_UnitMode(_ContextParam, _unit);
                    }
                    else
                    {
                        _ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                    }

                    return _ContextParam;
                }

                public BL.ZSBELearning.ContextParam RestoreNext(BL.ZSBELearning.ContextParam ContextParam)
                {
                    #region CompetenceTheory
                    if (ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceTheory)
                    {
                        ContextParam = RestoreNextExercise_NormalMode(ContextParam);
                    }
                    #endregion
                    else
                    {
                        #region Reszta kursów
                        if (ContextParam.Group == Dictionary.GroupType.Student)
                        {
                            if (ContextParam.IsCourseFinished)
                            {
                                    if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                                    {
                                        if (ContextParam.Mode == GM.N610.ELearning.BL.Dictionary.ModeType.History)
                                        {
                                            ContextParam = RestoreNextExercise_HistoryMode(ContextParam);
                                        }
                                        else
                                        {
                                            ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Summary;
                                        }
                                    }
                                    else if ((ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.StartSummary) || (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.Summary))
                                    {
                                        ContextParam = RestoreStartExercise_HistoryMode(ContextParam);
                                    }
                                    else
                                    {
                                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                                    }
                            }
                            else
                            {
                                ContextParam = Restore_RandomMode(ContextParam);
                            }
                        }
                        else
                        {
                            ContextParam = RestoreNextExercise_NormalMode(ContextParam);
                        }
                        #endregion
                    }
                    return ContextParam;
                }

                public BL.ZSBELearning.ContextParam RestorePrevious(BL.ZSBELearning.ContextParam ContextParam)
                {
                    #region CompetenceTheory
                    if (ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceTheory)
                    {
                        ContextParam = RestorePrevExercise_NormalMode(ContextParam);
                    }
                    #endregion
                    else
                    {
                        #region Reszta kursów
                        if (ContextParam.Group == Dictionary.GroupType.Student)
                        {
                            if (ContextParam.IsCourseFinished)
                            {
                                if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                                {
                                    ContextParam = RestorePrevExercise_HistoryMode(ContextParam);
                                }
                                else
                                {
                                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                                }
                            }
                            else
                            {
                                ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                            }
                        }
                        else
                        {
                            ContextParam = RestorePrevExercise_NormalMode(ContextParam);
                        }
                        #endregion
                    }
                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestoreStartExercise_NormalMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Exercise _lastStatistic_Exercise = BLP.BLELearning.Statistic.Exercise.RestoreLast(BLP.Environment.User,ContextParam.ContextObjectID, ContextParam.Course);

                    if (_lastStatistic_Exercise != null)
                    {
                        ContextParam.UnitOut = BLP.BLELearning.Unit.Restore(_lastStatistic_Exercise.UnitID);
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.Restore(_lastStatistic_Exercise.ExerciseID);
                    }
                    else
                    {
                        if (ContextParam.Units.Count > 0)
                        {
                            if (ContextParam.Units.Count > 1)
                            {
                                ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.CourseMenu;
                            }
                            else
                            {
                                ContextParam.UnitOut = ContextParam.Units[0];
                                ContextParam.ExerciseOut = BLP.BLELearning.Exercise.RestoreFirstExerciseForUnit(ContextParam.UnitOut);
                            }
                        }
                        else
                        {
                            ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                        }

                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestoreStartExercise_UnitMode(BL.ZSBELearning.ContextParam ContextParam, PI.GM.N610.ELearning.BL.BO.Unit Unit)
                {
                    ContextParam.UnitOut = Unit;
                    ContextParam.ExerciseOut = BLP.BLELearning.Exercise.RestoreFirstExerciseForUnit(Unit);

                    if (ContextParam.ExerciseOut == null)
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestoreNextExercise_NormalMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    if ((ContextParam.Group == Dictionary.GroupType.Student) && (!ContextParam.IsCompetencePartAvailable))
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;
                    }
                    else
                    {
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.RestoreNextExercise(ContextParam.UnitOut, ContextParam.ExerciseIn);

                        if (ContextParam.ExerciseOut == null)
                        {
                            ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                        }
                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestorePrevExercise_NormalMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    if ((ContextParam.Group == Dictionary.GroupType.Student) && (!ContextParam.IsCompetencePartAvailable))
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;
                    }
                    else
                    {
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.RestorePrevExercise(ContextParam.UnitOut, ContextParam.ExerciseIn);

                        if (ContextParam.ExerciseOut == null)
                        {
                            ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                        }
                    }
                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam Restore_RandomMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    /*
                     * 1. Czy zrobione są wszystkie ćwiczenia 
                     * 2. Jeżeli tak wyświetlić summary page
                     * 3. Nie 
                     *  a) wyznaczamy następny rozdział
                     *  b) losujemyu ćwiczenie z rozdziału
                     */

                    if (ContextParam.IsCourseFinished)
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Summary;
                    }
                    else
                    {
                        if (ContextParam.IsCompetencePartAvailable)
                        {
                            ContextParam.UnitOut = BLP.Unit.Restore(ContextParam);

                            if (ContextParam.UnitOut == null)
                            {
                                ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;
                            }
                            else
                            {
                                ContextParam.ExerciseOut = RestoreRandomize(ContextParam);
                            }
                        }
                        else
                        {
                            ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;
                        }
                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestoreStartExercise_HistoryMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Exercise _lastStatistic_Exercise = BLP.BLELearning.Statistic.History.RestoreFirst(BLP.Environment.User,ContextParam.ContextObjectID, ContextParam.Course);

                    if (_lastStatistic_Exercise != null)
                    {
                        ContextParam.UnitOut = BLP.BLELearning.Unit.Restore(_lastStatistic_Exercise.UnitID);
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.Restore(_lastStatistic_Exercise.ExerciseID);
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.None;
                    }
                    else
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Summary;
                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestoreNextExercise_HistoryMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Exercise _lastStatistic_Exercise = BLP.BLELearning.Statistic.History.RestoreNext(BLP.Environment.User,ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitIn, ContextParam.ExerciseIn);

                    if (_lastStatistic_Exercise != null)
                    {
                        ContextParam.UnitOut = BLP.BLELearning.Unit.Restore(_lastStatistic_Exercise.UnitID);
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.Restore(_lastStatistic_Exercise.ExerciseID);
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.None;
                    }
                    else
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.StartSummary;
                    }

                    return ContextParam;
                }

                private BL.ZSBELearning.ContextParam RestorePrevExercise_HistoryMode(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Exercise _lastStatistic_Exercise = BLP.BLELearning.Statistic.History.RestorePrev(BLP.Environment.User,ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitIn, ContextParam.ExerciseIn);

                    if (_lastStatistic_Exercise != null)
                    {
                        ContextParam.UnitOut = BLP.BLELearning.Unit.Restore(_lastStatistic_Exercise.UnitID);
                        ContextParam.ExerciseOut = BLP.BLELearning.Exercise.Restore(_lastStatistic_Exercise.ExerciseID);
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.None;
                    }
                    else
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.StartSummary;
                    }

                    return ContextParam;
                }

                private BL.BO.View.Exercise RestoreRandomize(BL.ZSBELearning.ContextParam ContextParam)
                {
                    BL.BO.View.Exercise.Search _search = new BO.View.Exercise.Search();
                    _search.UserID = BLP.Environment.User.ID;
                    _search.ContextObjectID = ContextParam.ContextObjectID;
                    _search.CourseID = ContextParam.Course.ID;
                    _search.UnitID = ContextParam.UnitOut.ID;

                    if (ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceCourse)
                    {
                        _search.ExerciseDifficultyID = ContextParam.ExerciseDifficultyID;
                    }

                    return BLP.DAL.ExerciseView.RestoreRandom(_search);
                }
            }
            #endregion

            #region Render
            private RenderBL _RenderBL = null;

            public RenderBL Render
            {
                get
                {
                    if (_RenderBL == null)
                    {
                        _RenderBL = new RenderBL(BLP);
                    }
                    return _RenderBL;
                }
            }

            public class RenderBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public RenderBL(ZSBELearning BL) : base(BL) { }

                public XmlDocument BreadcrumbsNavigation(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlExercise)
                {
                    if (ContextParam.PageCount < 2) return XmlExercise;

                    XmlNode _xmlBreadcrumbs = Gemini.Utility.XML.Node.Add(XmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLNodes.Breadcrumbs_Navigation, true);

//#if DEBUG
                    if (ContextParam.Group != Dictionary.GroupType.Student)
                    {
                        int _index = 1;
                        int _currentPosition = 0;

                        List<PI.GM.N610.ELearning.BL.BO.Exercise> _listUnitExercise = BLP.BLELearning.Exercise.RestoreActive(ContextParam.UnitOut);
                        foreach (PI.GM.N610.ELearning.BL.BO.Exercise _loopUnitExercise in _listUnitExercise)
                        {
                            XmlNode _xmlExercise = Gemini.Utility.XML.Node.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLNodes.Exercise, false);

                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.CourseID, ContextParam.Course.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.UnitID, ContextParam.UnitOut.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ExerciseID, _loopUnitExercise.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ContextObjectID, ContextParam.ContextObjectID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ModeID, (int)ContextParam.Mode);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Index, _index);

                            if (_loopUnitExercise.ID == ContextParam.ExerciseOut.ID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsCurrent, 1);
                                _currentPosition = _index;
                            }
                            else
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsCurrent, 0);
                            }
                            _index++;
                        }
                    }
//#endif

                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PagePosition, ContextParam.PageNr);
                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PageCounter, ContextParam.PageCount);

                    return XmlExercise;
                }

                public XmlDocument BreadcrumbsNavigation_History(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlExercise)
                {
                    if (ContextParam.AuxyliaryPages == Dictionary.AuxyliaryPagesType.None)
                    {
                        if (ContextParam.PageCount < 1) return XmlExercise;

                        XmlNode _xmlBreadcrumbs = Gemini.Utility.XML.Node.Add(XmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLNodes.Breadcrumbs_Navigation, true);


#if DEBUG
                        int _index = 1;
                        int _currentPosition = 0;

                        List<PI.GM.N610.ELearning.BL.BO.Exercise> _listUnitExercise = BLP.BLELearning.Exercise.RestoreActive(ContextParam.UnitOut);
                        foreach (PI.GM.N610.ELearning.BL.BO.Exercise _loopUnitExercise in _listUnitExercise)
                        {
                            XmlNode _xmlExercise = Gemini.Utility.XML.Node.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLNodes.Exercise, false);

                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.CourseID, ContextParam.Course.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.UnitID, ContextParam.UnitOut.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ExerciseID, _loopUnitExercise.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ContextObjectID, ContextParam.ContextObjectID);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ModeID, (int)ContextParam.Mode);
                            Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Index, _index);

                            if (_loopUnitExercise.ID == ContextParam.ExerciseOut.ID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsCurrent, 1);
                                _currentPosition = _index;
                            }
                            else
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsCurrent, 0);
                            }
                            _index++;
                        }
#endif

                        Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PagePosition, ContextParam.PageNr);
                        Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PageCounter, ContextParam.PageCount);
                    }
                    return XmlExercise;
                }

                public XmlDocument BreadcrumbsInfo(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlExercise)
                {
                    return XmlExercise;
                }

                public XmlDocument BreadcrumbsMenu(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlExercise)
                {
                    XmlNode _xmlBreadcrumbs = Gemini.Utility.XML.Node.Add(XmlExercise, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLNodes.Breadcrumbs_Menu, true);

                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ModeID, (int)ContextParam.Mode);

                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ContextObjectID, ContextParam.ContextObjectID);
                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.CourseID, ContextParam.Course.ID);
                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.UnitID, ContextParam.UnitOut.ID);
                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.ExerciseID, ContextParam.ExerciseOut.ID);
                    Gemini.Utility.XML.Attribute.Add(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Title, ContextParam.ExerciseOut.Title);

                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsCheck, ContextParam.BreadcrumbsMenu.IsCheck);
                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsReload, ContextParam.BreadcrumbsMenu.IsReload);
                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsResolve, ContextParam.BreadcrumbsMenu.IsResolve);
                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsMenu, ContextParam.BreadcrumbsMenu.IsMenu);
                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsNext, ContextParam.BreadcrumbsMenu.IsNextExercise);
                    Gemini.Utility.XML.Attribute.AddNormalized(XmlExercise, _xmlBreadcrumbs, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.IsPrev, ContextParam.BreadcrumbsMenu.IsPreviousExercise);

                    return XmlExercise;
                }

                public XmlDocument SummaryPage(BL.ZSBELearning.ContextParam ContextParam)
                {
                    XmlDocument _xml = null;
                    //if (ContextParam.PageCount > 0)
                    {
                        ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Summary;

                        _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.Summary);

                        Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);
                        Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.CourseType, (int)ContextParam.CourseType);
                        Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, "sex", ContextParam.Student.Sex == true ? 1 : 0);
                        Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, "name", ContextParam.Student.Forename);

                        switch (ContextParam.CourseType)
                        {
                            case Dictionary.Category.CourseType.AdvancedTest: SummaryAdvancedTest(ContextParam, _xml); break;
                            case Dictionary.Category.CourseType.Case: SummaryCase(ContextParam, _xml); break;
                            case Dictionary.Category.CourseType.CompetenceCourse: SummaryCompetenceCourse(ContextParam, _xml); break;
                            case Dictionary.Category.CourseType.KnowledgeTest: SummaryKnowledgeTest(ContextParam, _xml); break;
                        }

                        _xml = ValidContext(ContextParam, _xml);
                    }
                    //else
                    //{
                    //    _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.NoExercises);

                    //    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoExercises;
                    //}

                    return _xml;
                }

                public XmlDocument NoAccess(BL.ZSBELearning.ContextParam ContextParam)
                {
                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;

                    XmlDocument _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.NoAccess);

                    Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);

                    _xml = ValidContext(ContextParam,_xml);

                    return _xml;
                }

                public XmlDocument Redirect(BL.ZSBELearning.ContextParam ContextParam)
                {
                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.NoAccess;

                    XmlDocument _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.Redirect);

                    Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);

                    _xml = ValidContext(ContextParam, _xml);

                    return _xml;
                }

                public XmlDocument Error(BL.ZSBELearning.ContextParam ContextParam)
                {
                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;

                    XmlDocument _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.Error);

                    Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);

                    return _xml;
                }

                public XmlDocument NoExercises(BL.ZSBELearning.ContextParam ContextParam)
                {
                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Error;

                    XmlDocument _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.Error);

                    Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);

                    return _xml;
                }

                public XmlDocument Fraud(BL.ZSBELearning.ContextParam ContextParam)
                {
                    ContextParam.AuxyliaryPages = Dictionary.AuxyliaryPagesType.Fraud;

                    XmlDocument _xml = PI.GM.N610.ELearning.BL.ELearning.UtilityBL.GetXMLTemplate((int)Dictionary.AuxyliaryPagesType.Fraud);

                    Gemini.Utility.XML.Attribute.Add(_xml, _xml.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ExerciseEvent, PI.GM.N610.ELearning.BL.Dictionary.Exercise.Events.Load);

                    return _xml;
                }

                public XmlDocument Load(BL.ZSBELearning.ContextParam ContextParam, bool IsUserAuthorized)
                {
                    XmlDocument _XmlDocument = BLP.BLELearning.Exercise.Render.Load(ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitOut, ContextParam.ExerciseOut, null, ContextParam.Mode,IsUserAuthorized);

                    if ((ContextParam.Group == Dictionary.GroupType.Student) && 
                        (ContextParam.CourseType == Dictionary.Category.CourseType.Case || ContextParam.CourseType == Dictionary.Category.CourseType.CompetenceCourse))
                    {
                        BLP.Statistic.Student.CompetencePart.SaveLoad(ContextParam); 
                    }

                    return _XmlDocument;
                }

                public XmlDocument History(BL.ZSBELearning.ContextParam ContextParam)
                {
                    return BLP.BLELearning.Exercise.Render.History(ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitOut, ContextParam.ExerciseOut, ContextParam.Mode);
                }

                public XmlDocument Check(BL.ZSBELearning.ContextParam ContextParam, XmlNode ResponseNode, bool IsUserAuthorized)
                {
                    XmlDocument _xmlExercise = BLP.BLELearning.Exercise.Render.Check(ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitIn, ContextParam.ExerciseIn, null,ContextParam.Mode, ResponseNode, IsUserAuthorized);
                    
                    ContextParam.Refresh();
                    if (BLP.Course.IsFinised(ContextParam))
                    {
                        BLP.Statistic.Save(ContextParam);
                    }

                    return _xmlExercise;
                }

                public XmlDocument Resolve(BL.ZSBELearning.ContextParam ContextParam, XmlNode ResponseNode, bool IsUserAuthorized)
                {
                    XmlDocument _xmlExercise = BLP.BLELearning.Exercise.Render.Resolve(ContextParam.ContextObjectID, ContextParam.Course, ContextParam.UnitIn, ContextParam.ExerciseIn, null, ContextParam.Mode,ResponseNode, IsUserAuthorized);

                    return _xmlExercise;
                }

                private XmlDocument SummaryAdvancedTest(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlDocument)
                {
                    if (BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn) == ContextParam.Course.ID)
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, ContextParam.Student.AdvancedTestStartPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, ContextParam.Student.AdvancedTestStartMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, ContextParam.Student.AdvancedTestStartPointsPercent);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "start", 1);
                    }
                    else
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, ContextParam.Student.AdvancedTestEndPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, ContextParam.Student.AdvancedTestEndMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, ContextParam.Student.AdvancedTestEndPointsPercent);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "start", 0);                    
                    }

                    return XmlDocument;
                }

                private XmlDocument SummaryCompetenceCourse(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlDocument)
                {
                    BO.Student_CompetencePart _Student_CompetencePart = BLP.Statistic.Student.CompetencePart.Restore(ContextParam);

                    if (_Student_CompetencePart != null)
                    {

                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, _Student_CompetencePart.CompetencePointsByWeight);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, _Student_CompetencePart.CompetenceMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, BLP.Utility.PointPercent(_Student_CompetencePart.CompetencePointsByWeight, _Student_CompetencePart.CompetenceMaxPoints));                                             


                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "salary", (int)_Student_CompetencePart.Salary);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "salaryTotal", (int)ContextParam.Student.Salary);

                        #region Advanced Level
                        BO.AdvancedLevel _advancedLevelStart = BLP.AdvancedLevel.Restore(_Student_CompetencePart.AdvancedLevelID_Start);
                        BO.AdvancedLevel _advancedLevelEnd = BLP.AdvancedLevel.Restore(_Student_CompetencePart.AdvancedLevelID_End);

                        if (_advancedLevelStart != null)
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "advancedLevelStart", _advancedLevelStart.Name);
                        }

                        if (_advancedLevelEnd != null)
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "advancedLevelEnd", _advancedLevelEnd.Name);
                        }


                        int _advancedLevelProgress = 0;

                        if (_advancedLevelStart.Weight > _advancedLevelEnd.Weight)
                        {
                            _advancedLevelProgress = -1;
                        }

                        if (_advancedLevelStart.Weight < _advancedLevelEnd.Weight)
                        {
                            _advancedLevelProgress = 1;
                        }

                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "advancedLevelProgress", _advancedLevelProgress);
                        #endregion

                        #region Evaluation Sheet 
                        BO.EvaluationSheet _evaluationSheetStart = BLP.EvaluationSheet.Restore(_Student_CompetencePart.EvaluationSheetID_Start);
                        BO.EvaluationSheet _evaluationSheetEnd = BLP.EvaluationSheet.Restore(_Student_CompetencePart.EvaluationSheetID_End);

                        if (_evaluationSheetStart != null)
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "evaluationSheetStart", _evaluationSheetStart.Name);
                        }

                        if (_evaluationSheetEnd != null)
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "evaluationSheetEnd", _evaluationSheetEnd.Name);
                        }

                        int _evaluationSheetProgress = 0;

                        if (_evaluationSheetStart.Weight > _evaluationSheetEnd.Weight)
                        {
                            _evaluationSheetProgress = -1;
                        }

                        if (_evaluationSheetStart.Weight < _evaluationSheetEnd.Weight)
                        {
                            _evaluationSheetProgress = 1;
                        }

                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "evaluationSheetProgress", _evaluationSheetProgress);
                        #endregion
                    }

                    return XmlDocument;
                }

                private XmlDocument SummaryCase(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlDocument)
                {
                    BO.Student_CompetencePart _Student_CompetencePart = BLP.Statistic.Student.CompetencePart.Restore(ContextParam);

                    if (_Student_CompetencePart != null)
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, _Student_CompetencePart.CaseStudyPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, _Student_CompetencePart.CaseStudyMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, BLP.Utility.PointPercent(_Student_CompetencePart.CaseStudyPoints, _Student_CompetencePart.CaseStudyMaxPoints));
                    }

                    return XmlDocument;
                }

                private XmlDocument SummaryKnowledgeTest(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlDocument)
                {
                    BO.AdvancedLevel _advancedLevel = null;

                    if (BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn) == ContextParam.Course.ID)
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, ContextParam.Student.KnowledgeTestStartPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, ContextParam.Student.KnowledgeTestStartMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, ContextParam.Student.KnowledgeTestStartPointsPercent);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "start", 1);

                        _advancedLevel = BLP.AdvancedLevel.Restore(ContextParam.Student.KnowledgeTestStartAdvancedLevelID);
                    }
                    else
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.Points, ContextParam.Student.KnowledgeTestEndPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsMax, ContextParam.Student.KnowledgeTestEndMaxPoints);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, PI.GM.N610.ELearning.BL.Dictionary.AjaxCommunication.XMLAttributes.PointsPercent, ContextParam.Student.KnowledgeTestEndPointsPercent);
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "start", 0);

                        _advancedLevel = BLP.AdvancedLevel.Restore(ContextParam.Student.KnowledgeTestEndAdvancedLevelID);                    
                    }

                    if (_advancedLevel != null)
                    {
                        Gemini.Utility.XML.Attribute.Add(XmlDocument, XmlDocument.DocumentElement, "advancedLevel", _advancedLevel.Name);
                    }

                    return XmlDocument;
                }

                private XmlDocument ValidContext(BL.ZSBELearning.ContextParam ContextParam, XmlDocument XmlDocument)
                {
                    if (ContextParam.ValidContext != null)
                    {
                        XmlNode _validContext = Gemini.Utility.XML.Node.Add(XmlDocument, "ValidContext", true);
                        if ((ContextParam.ValidContext.CourseType == Dictionary.Category.CourseType.Case) || (ContextParam.ValidContext.CourseType == Dictionary.Category.CourseType.CompetenceCourse))
                        {
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "start", "0");
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "pt", "3");
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "partid", ContextParam.ValidContext.CompetencePart.ID);
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "competenceid", ContextParam.ValidContext.CompetencePart.CompetenceID);
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "contextid", ContextParam.ValidContext.ContextObjectID);
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "courseid", ContextParam.ValidContext.Course.ID);

                            switch (ContextParam.ValidContext.CourseType)
                            {
                                case Dictionary.Category.CourseType.CompetenceCourse: Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 2); break;
                                case Dictionary.Category.CourseType.Case: Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 1); break;
                            }                            
                        }
                        else
                        {
                            if (ContextParam.ValidContext.ContextObjectID == Dictionary.Config.Tests.StartKnowledgeTest.ContextObjectID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "start", "1");
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 10);
                            }
                            else  if(ContextParam.ValidContext.ContextObjectID == Dictionary.Config.Tests.StartAdvancedTest.ContextObjectID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "start", "0");
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 11);
                            }
                            else if (ContextParam.ValidContext.ContextObjectID == Dictionary.Config.Tests.EndKnowledgeTest.ContextObjectID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "start", "0");
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 12);
                            }
                            else if (ContextParam.ValidContext.ContextObjectID == Dictionary.Config.Tests.EndAdvancedTest.ContextObjectID)
                            {
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "start", "0");
                                Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "coursetype", 13);
                            }

                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "pt", "3");
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "contextid", ContextParam.ValidContext.ContextObjectID);
                            Gemini.Utility.XML.Attribute.Add(XmlDocument, _validContext, "courseid", ContextParam.ValidContext.Course.ID);
                        }
                    }

                    return XmlDocument;
                }
            }
            #endregion
        }
    }
}
